#!/usr/bin/env python
# -*- coding: utf-8 -*-
# SPDX-License-Identifier: LGPL-2.1-only
# Copyright (C) 2005, 2006, 2010, 2011 Andreas Büsching <crunchy@bitkipper.net>
# Copyright 2015-2022 Univention GmbH
# Author: Andreas Büsching <crunchy@bitkipper.net>

"""
log - a logging facility for the generic notifier module
"""

# CRITICAL is the same as FATAL
from logging import CRITICAL, DEBUG, ERROR, FATAL, INFO, WARN, FileHandler, Formatter, Handler, StreamHandler, getLogger  # noqa: F401
from sys import stderr

instance = getLogger('notifier')
formatter = Formatter("%(asctime)s: %(name)s: %(levelname)-8s: %(message)s")

debug = instance.debug
info = instance.info
warn = instance.warn
error = instance.error
critical = instance.critical
exception = instance.exception

set_level = instance.setLevel


def open(*arg):
	# type: (*Handler) -> None
	'''Add the given list of handlers. If no handler is given two
	default handlers will be installed that log to stderr and
	/var/log/python-notifier.log'''
	instance.handlers = []
	if not arg:
		try:
			file_handler = FileHandler('/var/log/python-notifier.log')
			file_handler.setFormatter(formatter)
			instance.addHandler(file_handler)
		except Exception:
			pass

		stream_handler = StreamHandler(stderr)
		stream_handler.setFormatter(formatter)
		instance.addHandler(stream_handler)
	else:
		for hdl in arg:
			instance.addHandler(hdl)


open()
