#!/usr/bin/env python
# -*- coding: utf-8 -*-
# SPDX-License-Identifier: LGPL-2.1-only
# Copyright (C) 2009 Andreas Büsching <crunchy@bitkipper.net>
# Copyright 2015-2022 Univention GmbH
# Author: Andreas Büsching <crunchy@bitkipper.net>

"""
an example demonstrating the process handler class RunIt
"""

from __future__ import print_function

import notifier
import notifier.popen


def tick():
	print('tick')
	return True


def give_birth():
	ls = notifier.popen.run('/bin/ls -ltr /etc', stderr=False, shell=False)
	# process dead?
	if ls.pid is None:
		print(ls.stdout.read())
		ls.stdout.close()

	sleep = notifier.popen.run('sleep 5', timeout=3, stderr=False, stdout=False, shell=False)
	if sleep.pid:
		print('process still running', sleep.pid)
		ret = notifier.popen.kill(sleep)
		print('killed', ret)

	return False


if __name__ == '__main__':
	notifier.init(notifier.GENERIC)

	# run processes
	notifier.timer_add(1500, give_birth)

	# show we can still do things
	notifier.timer_add(500, tick)

	notifier.loop()
