#!/usr/bin/env python
# -*- coding: utf-8 -*-
# SPDX-License-Identifier: LGPL-2.1-only
# Copyright (C) 2006 Andreas Büsching <crunchy@bitkipper.net>
# Copyright 2015-2022 Univention GmbH
# Author: Andreas Büsching <crunchy@bitkipper.net>

"""
an example demonstrating the process handler class RunIt
"""

from __future__ import print_function

import notifier
import notifier.popen


def tick():
	print('tick')
	return True


def find_result(pid, status, result):
	print('process %d died (%d)' % (pid, status))
	if result:
		print("output:%s lines" % len(result))
	else:
		print("output:%s" % result)


if __name__ == '__main__':
	notifier.init(notifier.GENERIC)

	# show we can still do things
	notifier.timer_add(500, tick)

	cmd = '/bin/sh -c "/bin/sleep 2 && /usr/bin/find /usr/bin"'
	# cmd = '/usr/bin/find /var/log'
	proc = notifier.popen.RunIt(cmd, stdout=True)
	proc.signal_connect('finished', find_result)
	print('started process', proc.start())

	notifier.loop()
