#!/usr/bin/env python
# -*- coding: utf-8 -*-
# SPDX-License-Identifier: LGPL-2.1-only
# Copyright (C) 2005, 2006, 2009 Andreas Büsching <crunchy@bitkipper.net>
# Copyright 2015-2022 Univention GmbH
# Author: Andreas Büsching <crunchy@bitkipper.net>

"""
logger example
"""

from __future__ import print_function

import os

import notifier


def tail_minus_f(logfile):
	new_size = os.stat(logfile.name)[6]
	if new_size > logfile.tell():
		buffer = logfile.read(65536)
		if buffer:
			print(buffer, end=' ')

	return True


if __name__ == '__main__':
	notifier.init()
	filename = '/var/log/messages'
	if not os.path.isfile(filename):
		filename = '/var/log/syslog'
	log = open(filename, 'rb')
	log.seek(os.stat(filename)[6])
	notifier.timer_add(100, notifier.Callback(tail_minus_f, log))
	notifier.loop()
