#!/usr/bin/env python
# -*- coding: utf-8 -*-
# SPDX-License-Identifier: LGPL-2.1-only
# Copyright (C) 2005, 2006, 2009 Andreas Büsching <crunchy@bitkipper.net>
# Copyright 2015-2022 Univention GmbH
# Author: Andreas Büsching <crunchy@bitkipper.net>

"""
logger example
"""

from __future__ import print_function

import logging
import os

import notifier.log as nflog

if __name__ == '__main__':
	# use default handlers
	print('>>> default handlers')
	# nflog.open() -> the default handlers are opened during import
	for level in (nflog.CRITICAL, nflog.ERROR, nflog.WARN, nflog.INFO, nflog.DEBUG):
		nflog.set_level(level)
		print('LEVEL: %d' % level)
		nflog.critical('critical')
		nflog.error('error')
		nflog.warn('warn')
		nflog.info('info')
		nflog.debug('debug')

	# use custom handlers
	print('>>> custom handlers')
	handler = logging.FileHandler('test.log')
	handler.setFormatter(nflog.formatter)
	nflog.open(handler)
	for level in (nflog.CRITICAL, nflog.ERROR, nflog.WARN, nflog.INFO, nflog.DEBUG):
		nflog.set_level(level)
		nflog.critical('LEVEL: %d' % level)
		nflog.critical('critical')
		nflog.error('error')
		nflog.warn('warn')
		nflog.info('info')
		nflog.debug('debug')
	for line in open('test.log').readlines():
		print(line, end=' ')
	os.unlink('test.log')
