# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class ImageTransform(Object):
    r"""
    ImageTransform - helper class to transform output of
    non-axis-aligned images
    
    Superclass: Object
    
    ImageTransform is a helper class to transform the output of image
    filters (i.e., filter that input ImageData) by applying the Index
    to Physical transformation frmo the input image, which can include
    origin, spacing, direction. The transformation process is threaded
    with SMPTools for performance.
    
    Typically in application the single method transform_point_set() is
    invoked to transform the output of an image algorithm (assuming that
    the image's direction/orientation matrix is non-identity). Note that
    PointSets encompass PolyData as well as UnstructuredGrids.
    In the future other output types may be added. Note that specific
    methods for transforming points, normals, and vectors is also
    provided by this class in case additional output data arrays need to
    be transformed (since transform_point_set() only processes data arrays
    labeled as points, normals, and vectors).
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImageTransform, obj, update, **traits)
    
    def transform_normals(self, *args):
        """
        transform_normals(m3:Matrix3x3, spacing:[float, float, float],
            da:DataArray) -> None
        C++: static void transform_normals(Matrix3x3 *m3,
            double spacing[3], DataArray *da)
        Given three-component normals represented by a DataArray,
        transform the normals using the matrix provided.
        """
        my_args = deref_array(args, [('vtkMatrix3x3', ['float', 'float', 'float'], 'vtkDataArray')])
        ret = self._wrap_call(self._vtk_obj.TransformNormals, *my_args)
        return ret

    def transform_point_set(self, *args):
        """
        transform_point_set(im:ImageData, ps:PointSet) -> None
        C++: static void transform_point_set(ImageData *im,
            PointSet *ps)
        transform_point_set(im:ImageData, ps:PointSet,
            transNormals:bool, transVectors:bool) -> None
        C++: static void transform_point_set(ImageData *im,
            PointSet *ps, bool transNormals, bool transVectors)
        Given a ImageData (and hence its associated orientation
        matrix), and an instance of PointSet, transform its points, as
        well as any normals and vectors, associated with the PointSet.
        This is a convenience function, internally it calls
        translate_points(), transform_points(), transform_normals(), and/or
        transform_vectors() as appropriate. Note that both the normals and
        vectors associated with the point and cell data are transformed
        unless the second signature is called, which controls whether to
        transform normals and/or vectors.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TransformPointSet, *my_args)
        return ret

    def transform_points(self, *args):
        """
        transform_points(m4:Matrix4x4, da:DataArray) -> None
        C++: static void transform_points(Matrix4x4 *m4,
            DataArray *da)
        Given x-y-z points represented by a DataArray, transform the
        points using the matrix provided.
        """
        my_args = deref_array(args, [('vtkMatrix4x4', 'vtkDataArray')])
        ret = self._wrap_call(self._vtk_obj.TransformPoints, *my_args)
        return ret

    def transform_vectors(self, *args):
        """
        transform_vectors(m3:Matrix3x3, spacing:[float, float, float],
            da:DataArray) -> None
        C++: static void transform_vectors(Matrix3x3 *m3,
            double spacing[3], DataArray *da)
        Given three-component vectors represented by a DataArray,
        transform the vectors using the matrix provided.
        """
        my_args = deref_array(args, [('vtkMatrix3x3', ['float', 'float', 'float'], 'vtkDataArray')])
        ret = self._wrap_call(self._vtk_obj.TransformVectors, *my_args)
        return ret

    def translate_points(self, *args):
        """
        translate_points(t:[float, ...], da:DataArray) -> None
        C++: static void translate_points(double *t, DataArray *da)
        Given x-y-z points represented by a DataArray, translate the
        points using the image origin. This method is useful if there is
        no orientation or spacing to apply.
        """
        my_args = deref_array(args, [('tuple', 'vtkDataArray')])
        ret = self._wrap_call(self._vtk_obj.TranslatePoints, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ImageTransform, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ImageTransform properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit ImageTransform properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ImageTransform properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

